/* 
 * File:   Effects.h
 * Author: User
 *
 * Created on 16 September 2014, 11:11 AM
 */

#ifndef EFFECTS_H
#define	EFFECTS_H

typedef enum { Echo, Reverb, Tremolo, Vibrato, Overdrive, Fuzz, Compression, NoiseGate, Flange, Phaser } EffectType;

typedef struct {
    int a1, a2;
} IIR_Coeffs;

typedef struct {
    int state1, state2;
} IIR_State;

typedef struct {
    EffectType cur_effect;
    struct {
        int amplitude, target_amplitude, delay, newdelay, transition;
    } echo;
    struct {
        int amplitude, target_amplitude, delay, newdelay, transition, reverb_amplitude, target_reverb_amplitude;
    } reverb;
    struct {
        int pos, sineadd, sinemult, target_sinemult;
    } tremolo;
    struct {
        int pos, frac, sineadd, sinemult, targetadd, targetmult;
    } vibrato;
    struct {
        int gain, softness, target_gain, target_softness;
    } overdrive;
    struct {
        int gain, softness, target_gain, target_softness;
    } fuzz;
    struct {
        int attack_rate, decay_rate, level, delay, maxdelay;
    } compress;
    struct {
        int max_threshold, min_threshold, delay, maxdelay, gain;
    } noisegate;
    struct {
        int pos, frac, sineadd, sinemult, targetadd, targetmult, flangedepth;
    } flange;
    struct {
        int pos, sineadd, mix, sample_rate;
    } phaser;
} EffectState;

extern EffectState g_effects[3];

void Effects_Init(EffectState* pState, unsigned long sample_rate, unsigned short param1, unsigned short param2);
void Effects_Adjust(EffectState* pState, unsigned long sample_rate, unsigned short param1, unsigned short param2);
signed short Effects_Apply(EffectState* pState, signed short* Buffer, unsigned long BufferPos, unsigned long BufferSize);
unsigned int Effects_GetLevel(EffectState* pState);

void Effects_Echo_Init(EffectState* pState, unsigned long sample_rate, unsigned short delay, unsigned short amplitude);
void Effects_Echo_Adjust(EffectState* pState, unsigned long sample_rate, unsigned short delay, unsigned short amplitude);
signed short Effects_Echo_Apply(EffectState* pState, signed short* Buffer, unsigned long BufferPos, unsigned long BufferSize);
unsigned int Effects_Echo_GetLevel(EffectState* pState);

void Effects_Reverb_Init(EffectState* pState, unsigned long sample_rate, unsigned short delay, unsigned short amplitude);
void Effects_Reverb_Adjust(EffectState* pState, unsigned long sample_rate, unsigned short delay, unsigned short amplitude);
signed short Effects_Reverb_Apply(EffectState* pState, signed short* Buffer, unsigned long BufferPos, unsigned long BufferSize);
unsigned int Effects_Reverb_GetLevel(EffectState* pState);

void Effects_Tremolo_Init(EffectState* pState, unsigned long sample_rate, unsigned short depth, unsigned short frequency);
void Effects_Tremolo_Adjust(EffectState* pState, unsigned long sample_rate, unsigned short depth, unsigned short frequency);
signed short Effects_Tremolo_Apply(EffectState* pState, signed short data);
unsigned int Effects_Tremolo_GetLevel(EffectState* pState);

void Effects_Vibrato_Init(EffectState* pState, unsigned long sample_rate, unsigned short depth, unsigned short frequency);
void Effects_Vibrato_Adjust(EffectState* pState, unsigned long sample_rate, unsigned short depth, unsigned short frequency);
signed short Effects_Vibrato_Apply(EffectState* pState, signed short* Buffer, unsigned long BufferPos, unsigned long BufferSize);
unsigned int Effects_Vibrato_GetLevel(EffectState* pState);

void Effects_Overdrive_Init(EffectState* pState, unsigned long sample_rate, unsigned short gain, unsigned short softness);
void Effects_Overdrive_Adjust(EffectState* pState, unsigned long sample_rate, unsigned short gain, unsigned short softness);
signed short Effects_Overdrive_Apply(EffectState* pState, signed short data);
unsigned int Effects_Overdrive_GetLevel(EffectState* pState);

void Effects_Fuzz_Init(EffectState* pState, unsigned long sample_rate, unsigned short gain, unsigned short softness);
void Effects_Fuzz_Adjust(EffectState* pState, unsigned long sample_rate, unsigned short gain, unsigned short softness);
signed short Effects_Fuzz_Apply(EffectState* pState, signed short data);
unsigned int Effects_Fuzz_GetLevel(EffectState* pState);

void Effects_Compression_Init(EffectState* pState, unsigned long sample_rate, unsigned short attack, unsigned short decay);
void Effects_Compression_Adjust(EffectState* pState, unsigned long sample_rate, unsigned short attack, unsigned short decay);
signed short Effects_Compression_Apply(EffectState* pState, signed short data);
unsigned int Effects_Compression_GetLevel(EffectState* pState);

void Effects_NoiseGate_Init(EffectState* pState, unsigned long sample_rate, unsigned short threshold, unsigned short hysteresis);
void Effects_NoiseGate_Adjust(EffectState* pState, unsigned long sample_rate, unsigned short threshold, unsigned short hysteresis);
signed short Effects_NoiseGate_Apply(EffectState* pState, signed short data);
unsigned int Effects_NoiseGate_GetLevel(EffectState* pState);

void Effects_Flange_Init(EffectState* pState, unsigned long sample_rate, unsigned short depth, unsigned short frequency);
void Effects_Flange_Adjust(EffectState* pState, unsigned long sample_rate, unsigned short depth, unsigned short frequency);
signed short Effects_Flange_Apply(EffectState* pState, signed short* Buffer, unsigned long BufferPos, unsigned long BufferSize);
unsigned int Effects_Flange_GetLevel(EffectState* pState);

void Effects_Phaser_Init(EffectState* pState, unsigned long sample_rate, unsigned short depth, unsigned short frequency);
void Effects_Phaser_Adjust(EffectState* pState, unsigned long sample_rate, unsigned short depth, unsigned short frequency);
signed short Effects_Phaser_Apply(EffectState* pState, signed short data);
unsigned int Effects_Phaser_GetLevel(EffectState* pState);

#endif	/* EFFECTS_H */
